/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.world;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.ServerHooker;
import dangerzone.ToDoList;
import dangerzone.biomes.Biome;
import dangerzone.biomes.BiomeManager;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.particles.Particle;
import dangerzone.particles.Particles;
import dangerzone.threads.NotifyBlockTicker;
import dangerzone.world.BreakChecks;
import dangerzone.world.Chunk;
import dangerzone.world.ChunkCache;
import dangerzone.world.Dimensions;
import dangerzone.world.ServerChunkCache;
import dangerzone.world.WorldDecorators;
import java.util.Random;

public class World {
    public ChunkCache chunkcache = null;
    public ServerChunkCache serverchunkcache = null;
    public Random rand;
    public boolean isServer = false;
    public int timetimer;
    public int lengthOfDay = 360;
    public long worldseed = 0L;

    public World(ChunkCache c, ServerChunkCache s) {
        this.chunkcache = c;
        this.serverchunkcache = s;
        this.rand = new Random(System.currentTimeMillis());
        this.isServer = false;
        this.timetimer = 0;
    }

    public Biome getBiome(int d, int x, int y, int z) {
        if (!this.isServer) {
            return null;
        }
        if (Dimensions.getBiomeManager(d) == null) {
            return null;
        }
        Chunk t = DangerZone.server_chunk_cache.getChunk(this, d, x, y, z);
        if (t != null && t.mybiome != null) {
            return t.mybiome;
        }
        return Dimensions.getBiomeManager(d).getBiomeForChunk(t, d, x, y, z);
    }

    public BiomeManager getBiomeManager(int d, int x, int y, int z) {
        if (!this.isServer) {
            return null;
        }
        return Dimensions.getBiomeManager(d);
    }

    public int getblock(int d, int x, int y, int z) {
        if (this.isServer) {
            return this.serverchunkcache.getBlock(this, d, x, y, z);
        }
        return this.chunkcache.getBlock(this, d, x, y, z);
    }

    public int getblockmeta(int d, int x, int y, int z) {
        if (this.isServer) {
            return this.serverchunkcache.getBlockmeta(this, d, x, y, z);
        }
        return this.chunkcache.getBlockmeta(this, d, x, y, z);
    }

    public void setblock(int d, int x, int y, int z, int id) {
        if (this.isServer) {
            this.serverchunkcache.setBlock(this, d, x, y, z, id, 0);
            if (this.serverchunkcache.isDecorated(d, x, y, z)) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, 0);
            if (DangerZone.start_server) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        }
    }

    public void setblockandmeta(int d, int x, int y, int z, int id, int meta) {
        if (this.isServer) {
            this.serverchunkcache.setBlock(this, d, x, y, z, id, meta);
            if (this.serverchunkcache.isDecorated(d, x, y, z)) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, meta);
            if (DangerZone.start_server) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        }
    }

    public void setblocknonotify(int d, int x, int y, int z, int id) {
        if (this.isServer) {
            this.serverchunkcache.setBlock(this, d, x, y, z, id, 0);
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, 0);
        }
    }

    public void setblockandmetanonotify(int d, int x, int y, int z, int id, int meta) {
        if (this.isServer) {
            this.serverchunkcache.setBlock(this, d, x, y, z, id, meta);
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, meta);
        }
    }

    public boolean setblockWithPerm(Entity e, int d, int x, int y, int z, int id) {
        if (this.isServer) {
            if (!BreakChecks.canChangeBlock(e, d, x, y, z, id, 0)) {
                return false;
            }
            this.serverchunkcache.setBlock(this, d, x, y, z, id, 0);
            if (this.serverchunkcache.isDecorated(d, x, y, z)) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
            if (e != null && e instanceof Player) {
                Player pl = (Player)e;
                ToDoList.onPlaced(pl, d, x, y, z, id);
            }
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, 0);
            if (DangerZone.start_server) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        }
        return true;
    }

    public boolean setblockandmetaWithPerm(Entity e, int d, int x, int y, int z, int id, int meta) {
        if (this.isServer) {
            if (!BreakChecks.canChangeBlock(e, d, x, y, z, id, meta)) {
                return false;
            }
            this.serverchunkcache.setBlock(this, d, x, y, z, id, meta);
            if (this.serverchunkcache.isDecorated(d, x, y, z)) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
            if (e != null && e instanceof Player) {
                Player pl = (Player)e;
                ToDoList.onPlaced(pl, d, x, y, z, id);
            }
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, meta);
            if (DangerZone.start_server) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        }
        return true;
    }

    public boolean setblocknonotifyWithPerm(Entity e, int d, int x, int y, int z, int id) {
        if (this.isServer) {
            if (!BreakChecks.canChangeBlock(e, d, x, y, z, id, 0)) {
                return false;
            }
            this.serverchunkcache.setBlock(this, d, x, y, z, id, 0);
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, 0);
        }
        return true;
    }

    public boolean setblockandmetanonotifyWithPerm(Entity e, int d, int x, int y, int z, int id, int meta) {
        if (this.isServer) {
            if (!BreakChecks.canChangeBlock(e, d, x, y, z, id, meta)) {
                return false;
            }
            this.serverchunkcache.setBlock(this, d, x, y, z, id, meta);
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, meta);
        }
        return true;
    }

    public void decorate(World world, int dimension, Biome b, int chunkx, int chunkz) {
        if (!this.isServer) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (WorldDecorators.WorldDecoratorArray[i] == null) break;
            WorldDecorators.WorldDecoratorArray[i].decorate(world, dimension, b, chunkx, chunkz);
            ++i;
        }
    }

    public Entity createEntityByName(String name, int dimension, double x, double y, double z) {
        Entity e = ServerHooker.spawnEntityByName(name, this, dimension, x, y, z);
        if (e == null) {
            e = Entities.spawnEntityByName(name, this);
        }
        if (e == null) {
            return null;
        }
        e.dimension = dimension;
        e.posx = x;
        e.posy = y;
        e.posz = z;
        e.rotation_yaw = e.rotation_yaw_head = (float)this.rand.nextInt(360);
        return e;
    }

    public void spawnEntityInWorld(Entity e) {
        if (this.isServer && DangerZone.server.entityManager.addEntity(e) > 0) {
            DangerZone.server.sendSpawnEntityToAll(e);
        }
    }

    public Particle createParticleByName(String name, int dimension, double x, double y, double z) {
        if (this.isServer) {
            return null;
        }
        Particle e = Particles.spawnParticleByName(name);
        if (e == null) {
            return null;
        }
        e.dimension = dimension;
        e.posx = x;
        e.posy = y;
        e.posz = z;
        return e;
    }

    public void spawnParticleInWorld(Particle e) {
        if (this.isServer) {
            return;
        }
        DangerZone.clientParticleManager.addParticle(e);
    }

    public void playSound(String name, int dimension, double posx, double posy, double posz, float volume, float frequency) {
        if (name == null) {
            return;
        }
        if (name.equals("")) {
            return;
        }
        if (this.isServer) {
            DangerZone.server.sendSoundToAll(name, dimension, posx, posy, posz, volume, frequency);
        } else {
            DangerZone.server_connection.sendSound(name, dimension, posx, posy, posz, volume, frequency);
            DangerZone.soundmangler.playSound(name, volume, frequency, dimension, posx, posy, posz);
        }
    }

    public void playSoundCloseClient(String name, int dimension, double posx, double posy, double posz, float volume, float frequency) {
        if (name == null) {
            return;
        }
        if (name.equals("")) {
            return;
        }
        if (!this.isServer) {
            DangerZone.soundmangler.playSoundClose(name, volume, frequency, dimension, posx, posy, posz);
        }
    }

    public boolean isDaytime() {
        return this.timetimer < this.lengthOfDay / 2;
    }

    public int getTimeOfDay() {
        return this.timetimer;
    }

    public int getLengthOfDay() {
        return this.lengthOfDay;
    }
}

